<?php
/*======================================================================*\
|| #################################################################### ||
|| #				vB Pager for vBulletin 3.5.x					  # ||
|| #						Version 3.0.0							  # ||
|| #					by [eljazy.net]							  # ||
|| # ---------------------------------------------------------------- # ||
|| # 	Copyright 20002006 WwW.eljazy.net All Rights Reserved.      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('LOCATION_BYPASS', 1);
define('NOCOOKIES', 1);
define('THIS_SCRIPT', 'pager');
define('VB_AREA', 'Forum');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('fronthelp', 'vbpager', 'wol');

// pre-cache templates used by all actions
$globaltemplates = array('forumdisplay_sortarrow');

// pre-cache templates used by specific actions
$actiontemplates = array(
	'buddylist' => array(
		'PAGERBUDDYLIST',
		'pagerbuddylistbit'
	),
		'editlist' => array(
		'PAGERBUDDYLIST',
		'modifylistbit'
	),
		'log' => array(
		'pager_messagelist',
		'pager_messagelistbit'
		)
);

if (empty($_REQUEST['do']))
{
 $_REQUEST['do'] = 'buddylist';
}

// ######################### REQUIRE BACK-END ############################

require_once('./global.php');
	
$pagerinfo = array();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ###################### Start read pager message #######################
if ($_REQUEST['do'] == 'readpager')
 {
	if (!$vbulletin->options['vbpager_active'])
	 {
		exit;
	 }
			
	if ($vbulletin->userinfo['userid']==0)
	 {
		exit;
	 }

	if ($vbulletin->userinfo['pagerunread'] <= 0)
	 {
	 	exit;
	 }
	 
	$pagerinfo = $db->query_first("SELECT p.pagerid, p.fromuserid, p.fromusername, p.message, 
						p.dateline, p.canreply, p.hidden, r.receiptid, r.tousername, r.sendtime, 
						r.readtime, r.active FROM " . TABLE_PREFIX . "pagertext AS p 
						LEFT JOIN " . TABLE_PREFIX . "pagerreceipt AS r ON (p.pagerid = r.pagerid) 
						WHERE (p.deleted = '0' AND r.readtime = '0' AND 
						r.markdeleted = 0 AND r.touserid = '" . $vbulletin->userinfo['userid'] . "')
						ORDER BY dateline ASC");

	$pagerinfo['recivepager']		= TRUE;
	$pagerinfo['pagerreply']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerreply']);
	$pagerinfo['pagercanuse']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagercanuse']);
	$pagerinfo['pagercanhide']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerhidename']);
	$pagerinfo['pagerdisableduser']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerdisableduser']);
	$pagerinfo['pagerinignorelist']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerinignorelist']);
	$pagerinfo['pagertoall']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagertoall']);
	$pagerinfo['pagerminpost']		= $permissions['pagerminpost'];
	$pagerinfo['pagerminpostperday']= $permissions['pagerminpostperday'];
	$pagerinfo['pagermaxperday']	= $permissions['pagermaxperday'];
	$pagerinfo['pagersendmax']		= intval($permissions['pagersendmax']);
	$pagerinfo['pagersendmaxchar']	= $permissions['pagersendmaxchar'];
	$pagerinfo['pagerquota']		= $permissions['pagerquota'];
	
	 $pagerinfo['canreply']	= ($pagerinfo['pagerreply'] && $pagerinfo['canreply']) ? TRUE : $pagerinfo['canreply'] ;
	 
	if ($pagerinfo['pagerid'])
	 { 	
		$pagerinfo['vbpager_message_maxchar'] = $permissions['pagersendmaxchar'];
		$pagerinfo['timesent']	 = vbdate($vbulletin->options['dateformat'], $pagerinfo['dateline'], true) . " ";
		$pagerinfo['timesent']	.= vbdate($vbulletin->options['timeformat'], $pagerinfo['dateline'], true);

	// Check if was sent with hide username
	if ($pagerinfo['hidden'])
	 {
		$pagerinfo['fromusername']		= $vbphrase['n_a'];
		$pagerinfo['avatarurl']			= "$stylevar[imgdir_statusicon]/vbpager.gif";
		$pagerinfo['avatarheightwidth']	= "";
	 }
	else
	 {	 
		require_once('./includes/functions_user.php');
		$pagerinfo['avatar'] = fetch_avatar_url($pagerinfo['fromuserid']);
		
		if (!is_array($pagerinfo['avatar']))
		{
			$pagerinfo['avatarurl'] = "$stylevar[imgdir_statusicon]/vbpager.gif";
		}
		else
		{
			$pagerinfo['avatarurl']			= $vbulletin->options['bburl'] . "/" . $pagerinfo['avatar'][0];
			$pagerinfo['avatarheightwidth']	= $pagerinfo['avatar'][1];
		}
	}

	// Check usergroup permissions 
	if (!$pagerinfo['pagercanuse'])
	 {
		$pagererror['pagercanuse']	= TRUE;
	 }
	else
	 {
	// Check pager banned users
	if (vbpager_ban_user())
	 {
		$pagererror['banuser']	= TRUE;
	 }

	// Check for Today's Max Pager allowed
	if ($pagerinfo['pagermaxperday'] > 0)
	 {
		$pagerinfo['pagertoday']	= vbpager_pagertoday();
	 	if ($pagerinfo['pagertoday'] >= $pagerinfo['pagermaxperday'])
	 	 {
			$pagererror['pagermaxperday']	= 1;
		 }
	 }

	// Check for Pager messages quota (Inbox/Outbox)
	if ($pagerinfo['pagerquota'])
	 {
	 	$pagerinfo['pagertotal'] 		= vbpager_totalpager();
 	 	$pagerinfo['pagerquotaleft']	= $pagerinfo['pagerquota'] - $pagerinfo['pagertotal'];	 
	 	if ($pagerinfo['pagerquotaleft'] <= 0)
	 	 {
	 	 	$pagererror['pagerquota']	= 1;
	 	 }
	 }

		// Check for Minimum posts required per day
		if ($pagerinfo['pagerminpostperday'])
		{
			$posttodaycheck = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "post 
					WHERE userid=" . $vbulletin->userinfo['userid'] . " AND visible = 1 
					AND dateline < " . TIMENOW . " AND dateline > " . (TIMENOW-(24*60*60)));
			
		$pagerinfo['poststoday']	=	$posttodaycheck['count'];
			if ($pagerinfo['poststoday'] < $pagerinfo['pagerminpostperday'])
			{
				$pagerinfo['pagerminpostperday'] = round((float)$pagerinfo['pagerminpostperday'], 2);
				$pagererror['minpostperday']	= TRUE;
			}
		}

		// Check for Minimum post required before sending sending new pager
		if (($vbulletin->userinfo['posts'] < $pagerinfo['pagerminpost']) AND ($pagerinfo['pagerminpost'] > 0))
		 {		
			$pagererror['minpost']	= TRUE;
		 }
	 }
// End of Error handle..

		// Check for Smilies/vB code
		$pagerinfo['message'] = ($vbulletin->options['vbpager_pagerallowsmilies']) ? parse_pager_bbcode($pagerinfo['message']) : $pagerinfo['message'] ;

eval('print_output("' . fetch_template('pager_newpager') . '");');
 	exit;	 
	 }
exit;
 }

// ###################### AJAX UPDATE (BUDDY/IGNORE) #######################
if ($_REQUEST['do'] == 'ajaxbuddyignore')
 {
	// Check for Login user....
	$bid	= intval($_REQUEST['bid']);
	$iid	= intval($_REQUEST['iid']);
	$id		= ($bid) ? $bid : $iid ;	

 	if (($vbulletin->userinfo['userid']==0) OR ($id==0 AND intval($_REQUEST['delid'])==0))
 	 {
		exit;
	 }

// ###################### Remove Buddy/Ignore Userid #####################
	if (intval($_REQUEST['delid']) != 0)
	 {
 		$id	= intval($_REQUEST['delid']);
		$imgobj	= "vbpager_user_remove.gif";
		if ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden'])
		 {
		  	$uinfo = fetch_userinfo($id);
	 		$imgobj	= ($uinfo['invisible']) ? "vbpager_user_invisible.gif" : "vbpager_user_remove.gif";
	 	 }
	  echo "$imgobj";
	 }
	 
	// Check if userid exist in the Pager Buddylist
	$userids = str_replace(' ', ',', trim($vbulletin->userinfo["pagerbuddylist"]));
	$checkbuddyids = ($userids) ? explode(',', $userids) : '0';

		if ($checkbuddyids)
		{
		 	if (in_array($id, $checkbuddyids))
			 {
		 	  $updateopp = 1;
		 	  $tempids = array();
		 	  $tempids[] = 0;
		 		foreach ($checkbuddyids AS $ids)
		 	 	 {
		 	 		if ($ids != $id)
		 	 		 {
		 	 	 		$tempids[] = $ids;
		 	 	  	 }
		 		 }
		 	   $checkbuddyids = ($tempids) ? $tempids : $checkbuddyids ;
			 }
		}

	// Check if userid exist in the Pager Ignorelist
	$userids = str_replace(' ', ',', trim($vbulletin->userinfo["pagerignorelist"]));
	$checkignoreids = ($userids) ? explode(',', $userids) : '0';

		if ($checkignoreids)
		 {
		  if (in_array($id, $checkignoreids))
		  {
		 		$updateopp = 1;
		 		$tempids = array();
		 		$tempids[] = 0;
		 	foreach ($checkignoreids AS $ids)
		 	 {
		 	 	if ($ids != $id)
		 	 	 {
		 	 	 	$tempids[] = $ids;
		 	 	 }
		 	 }
		 	 	$checkignoreids = ($tempids) ? $tempids : $checkignoreids;
		  }
		 }

	require_once(DIR . '/includes/functions_databuild.php');
	build_usertextfields("pagerbuddylist", $checkbuddyids);
	build_usertextfields("pagerignorelist", $checkignoreids);

	if (intval($_REQUEST['delid']) != 0)
	 {
	 	// Exit if removing a user from pager buddy/ignore list...
		exit;
	 }

// ###################### Remove Buddy/Ignore Userid #####################
	if ($bid)
	 { 	
		$var	= "pagerbuddylist";
		$oppvar = "pagerignorelist";
		$imgobj = "vbpager_user_buddylist_";
	 }
	else
	 {
		$var	= "pagerignorelist";
		$oppvar = "pagerbuddylist";
		$imgobj	= "vbpager_user_ignorelist_";
	 }	
		
	$userids = str_replace(' ', ',', trim($vbulletin->userinfo["$oppvar"]));

	// Check if userid exist in the Pager Buddy/Ignorelist (opp field)
	$checkbuddyids = ($userids) ? explode(',', $userids) : array('0');

		if ($checkbuddyids)
		{
		 	if (in_array($id, $checkbuddyids))
		 	 {
		 		$updateopp = 1;
		 		$tempids = array();
		 		$tempids[] = 0;
		 			foreach ($checkbuddyids AS $ids)
		 			 {
		 			 	if ($ids != $id)
		 			 	 {
					 	 	 $tempids[] = $ids;
					 	 }
				 	 	$checkbuddyids = ($tempids) ? $tempids : $checkbuddyids;
					 }
			 }
		} 

	// Check if userid exist in the Pager Buddy/Ignorelist (same field)
	$userids = str_replace(' ', ',', trim($vbulletin->userinfo["$var"]));
	
	$buddyignoreids = ($userids) ? explode(',', $userids) : array('0');
	
	$id = ($bid) ? $bid : $iid;
		if ($buddyignoreids)
		 {  
			if (!in_array($id, $buddyignoreids))
			 {
			 	$buddyignoreids[] = $id;
		 	 }
			$updatebuddyignore = 1;	 	
		 }

	require_once(DIR . '/includes/functions_databuild.php');

	 if($updateopp)
	  {
		build_usertextfields($oppvar, $checkbuddyids);
	  }
	 if($updatebuddyignore)
	  {
		build_usertextfields($var, $buddyignoreids);
	  }

	if (($updateopp == 0) AND (!$updatebuddyignore))
	 {
		if($bid)
		 {
			build_usertextfields('pagerbuddylist', $bid);
		 }
		if($iid)
		 {
			build_usertextfields('pagerignorelist', $iid);
		 }
	 }	
// Return Icons

		if ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden'])
		 {
	 		$uinfo = fetch_userinfo($id);
	 		$imgobj	= ($uinfo['invisible']) ? $imgobj . "invisible.gif" : $imgobj . "online.gif" ;
		 }
		else
		 {
			$imgobj	= $imgobj . "online.gif";
		 }

		 echo "$imgobj";
 exit;
 }

// ###################### Close Pager / Reply Pager #####################

if ($_REQUEST['do']=='pagerreply')
 {
	$msg		= $_REQUEST['message'];
	$rid		= $_REQUEST['rid'];
	$canreply	= $_REQUEST['canreply'];

	if (empty($rid) AND empty($msg))
	 {
		exit;
	 }
	
	$pagerreply	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerreply']);
	if ($pagerreply == 0)
	 {
		$canreply = 0;
	 }

	$result = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "pagerreceipt WHERE receiptid = '$rid'");
	if (!$result)
	 {
		exit;
	 }
			
	// Exit if this message already been read by user
	if ($result['readtime'] > 0)
	 {
		exit;
	 }

	// Close pager and update (pager receipt)
	if ($result)
	 {
	 	$dbresult = $db->query_write("UPDATE " . TABLE_PREFIX . "pagerreceipt SET readtime = '" . TIMENOW . "' 
	 				WHERE receiptid = '$rid'");
		$updatecount = vbpager_update_unread($vbulletin->userinfo['userid']);
	 }

// Replied Pager message confirmation receipt
	if ($rid AND $msg)
	 {
			$replyinfo = $db->query_first("SELECT p.pagerid, p.fromuserid, p.fromusername
					FROM " . TABLE_PREFIX . "pagertext AS p LEFT JOIN " . TABLE_PREFIX . 
					"pagerreceipt AS r ON (p.pagerid = r.pagerid) 
					WHERE r.receiptid = $rid ");		
	 	// Sending New Pager as reply....
		if($replyinfo)
		 {
			// Check Max number of Members selection to send 
			$fromuserid		= $vbulletin->userinfo['userid'];
			$fromusername	= addslashes($vbulletin->userinfo['username']);

			// Send Pager
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "pagertext (fromuserid, fromusername, 
					message, dateline, canreply, pagerreplyid) VALUES (
					'$fromuserid', '$fromusername', '" . addslashes(convert_urlencoded_unicode($msg)) . "', '" . 
					TIMENOW . "','$canreply', '$rid')");
					
			$pagerid = $db->insert_id();
			$uid		= $replyinfo['fromuserid'];
			$tousername = addslashes($replyinfo['fromusername']);
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "pagerreceipt (pagerid, userid, touserid, 
			 		tousername, sendtime) VALUES ('$pagerid', '$fromuserid', '$uid', '$tousername', " . 
			 		TIMENOW . ")");	

				// Update users UNREAD Pagers in the user table
				$updatecount = vbpager_update_unread($uid);
				$updatecount = vbpager_update_unread($fromuserid);
		 }
	 }
exit;	
 }

// ###################### New PAGER-PRE (Profile Check) #####################
if ($_REQUEST['do'] == 'newpagertouser')
 {
 	$pagerinfo['pagersendmaxchar']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagersendmaxchar']);
	$pagerinfo['pagercanuse']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagercanuse']);
	$pagerinfo['pagercanhide']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerhidename']);
	$pagerinfo['pagerreply']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerreply']);
	$pagerinfo['pagerdisableduser']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerdisableduser']);
	$pagerinfo['pagerinignorelist']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerinignorelist']);	
	$pagerinfo['pagertoall']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagertoall']);	
	$pagerinfo['pagerquota']		= $permissions['pagerquota'];
	$pagerinfo['pagermaxperday']	= $permissions['pagermaxperday'];
	$pagerinfo['pagersendmax']		= intval($permissions['pagersendmax']);

	$userids		= array();
	$pagerusername	= array();
	$pageruserid	= array();
	$uids 			= "0, ";
	$userids		= $_REQUEST['userid'];
	$usercount		= 0;
	
		if ($userids)
		 {
		 	$usercount = count($userids);
			$uids .= implode(",", $userids);
		 }

 		$users = $db->query_read("SELECT user.username, user.lastvisit, (user.options & 
			" . $vbulletin->bf_misc_useroptions['invisible'] . ") 
			AS invisible, user.userid, user.lastactivity AS lastactive, 
			user.pageroption, user.pagerbuddyoption, usertextfield.pagerbuddylist, 
			usertextfield.pagerignorelist 
			FROM " . TABLE_PREFIX . "user AS user 
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON 
			(usertextfield.userid = user.userid) WHERE user.userid IN ($uids)
			ORDER BY user.userid");
			
 	while ($user = $db->fetch_array($users))
	{
 	 	$pagerusername[] = $user['username'];
 	 	$pageruserid[]	 = $user['userid'];

		// Buddy User's permission to use pager
		if ($pagerinfo['pagertoall'] == 0)
		{
			// ******* $pagerinfo['inignorelist'] ******* Buddy User ignored the loggedin user
			if ($user['pagerignorelist'])
			 {
				$tempignore = explode(' ', $user['pagerignorelist']);
				if (in_array($vbulletin->userinfo['userid'], $tempignore))
				 {
				 	$pagerinfo['errorinfo']	= "error";
					$pagerinfo['errorusername']	= $user['username'];
				 }
		  	 }

			// ******* $pagerinfo['disabledpager'] ******* Buddy User Disabled the Pager
			if ($user['pageroption'] == 0)
			 {
			 	$pagerinfo['errorinfo']	= "error";
				$pagerinfo['errorusername']	= $user['username'];
			 }

			// ******* $pagerinfo['pagerfrombuddy'] ******* Buddy User Accept the Pager only from HIS/HER Buddylist...
			if($user['pagerbuddyoption'])
			 {
				if ($user['pagerbuddylist'])
				 {
					$tempignore = explode(' ', $user['pagerbuddylist']);
					if (!in_array($vbulletin->userinfo['userid'], $tempignore))
					 {
			 			$pagerinfo['errorinfo']	= "error";
						$pagerinfo['errorusername']	= $user['username'];
					 }
		 		 }
				 else
				 {
  			 		$pagerinfo['errorinfo']	= "error";
					$pagerinfo['errorusername']	= $user['username'];
		  		 }
		  	 }
		}

// ******* User Can't sent Pager to SELF **********
			if ($user['userid'] == $vbulletin->userinfo['userid'])
			 {
			 	$pagerinfo['errorinfo']	= "error";
				$pagerinfo['errorselfuser']	= $user['username'];
			 }
	}
	
	if ($pagerusername)
	 {
		 $pagerinfo['pagerusername'] = implode(", ", $pagerusername);
	 }

// Here we check all the error messages before sending a pager
	// Check for BANNED User
	if (vbpager_ban_user())
	 {
		$pagerinfo['errorinfo'] = "error";
		$pagerinfo['banuser']	= TRUE;
	 }

	// Check for Max Pager allowed per day
	if ($pagerinfo['pagermaxperday'] != 0)
	 {
		$pagerinfo['pagertoday']	= vbpager_pagertoday();
	 	$pagerinfo['pagerlefttoday']= $pagerinfo['pagermaxperday'] - $pagerinfo['pagertoday'];		

	 	if (($pagerinfo['pagertoday'] >= $pagerinfo['pagermaxperday']) OR ($usercount > $pagerinfo['pagerlefttoday']))
	 	 {
			$pagerinfo['errorinfo'] 		= "error";
			$pagererror['pagermaxperday']	= TRUE;
		 }
	 }
	 
	// Check for Floodcheck
	if (!vbpager_floodcheck())
	 {
		$pagerinfo['errorinfo'] = "error";
		$pagerinfo['flooded']	= TRUE;
		$pagerinfo['floodtime']	= $vbulletin->options['vbpager_floodtime'];
	 }

	// Check for pagerquota
	if ($pagerinfo['pagerquota'] > 0)
	 {
	 	$pagerinfo['pagertotal'] 		= vbpager_totalpager();
 	 	$pagerinfo['pagerquotaleft']	= $pagerinfo['pagerquota'] - $pagerinfo['pagertotal'];
	 	if ($pagerinfo['pagerquotaleft'] <= 0)
	 	 {
			$pagerinfo['errorinfo']		= "error";
			$pagerinfo['messagestore']	= $pagerinfo['pagerquota'];
	 	 }
	 }

	$pagerinfo['canreply']					= TRUE;
	$pagerinfo['sendnewpager']				= TRUE;
	$pagerinfo['vbpager_message_maxchar']	= $permissions['pagersendmaxchar'];

	if ($pagerinfo['errorinfo'])
	 {
		$pagerinfo['sendnewpager'] = FALSE;
	 }

	if ($pageruserid)
	 {
		$pagerinfo['touserids']	 = implode(",", $pageruserid);
	 }

$pagerinfo['username']	 = $vbulletin->userinfo['username'] ;
$pagerinfo['timesent']	 = vbdate($vbulletin->options['dateformat'], TIMENOW, true) . " ";
$pagerinfo['timesent']	.= vbdate($vbulletin->options['timeformat'], TIMENOW, true);

eval('print_output("' . fetch_template('pager_mutlipager') . '");');
exit;
 }

// #######################################################################
// ######################### Sending New PAGER  ##########################
// #######################################################################

if ($_REQUEST['do'] == 'sendpager')
 {	
 	$touname	= $_REQUEST['unames'];
 	$touids		= $_REQUEST['uids'];
	$message	= $_REQUEST['message'];
	$canreply	= $_REQUEST['canreply'];
	$canhide	= $_REQUEST['canhide'];

	if ($touids)
	 {
		$touserids = explode(",", $touids);
	 }
	else
	 {
		$touserids[] = $touids;
	 }
		 
	$tousers = serialize($touids);
	if (vbpager_cansend($permissions))
	 { 	 
		$canhide = ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerhidename']) ? $canhide : FALSE;
		$canreply = ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerreply']) ? $canreply : FALSE;
	
		$fromuserid		= $vbulletin->userinfo['userid'];
		$fromusername	= addslashes($vbulletin->userinfo['username']);
		$tousers		= serialize($touids);
				
		// Let's Send Pager
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "pagertext (fromuserid, fromusername, 
					message, touserarray, dateline, canreply, hidden) VALUES (
					'$fromuserid', '$fromusername', '" . addslashes(convert_urlencoded_unicode($message)) . "', '$tousers', '" . 
					TIMENOW . "', '$canreply', '$canhide')"); 

		$pagerid = $db->insert_id();
			foreach ($touserids AS $uid)
			 {
			 	if ($uid != $fromuserid)
			 	 {
			 		$user = fetch_userinfo($uid);
			 		$tousername = addslashes($user['username']);
			 		$db->query_write("INSERT INTO " . TABLE_PREFIX . "pagerreceipt (pagerid, userid, touserid, 
			 			tousername, sendtime) VALUES ('$pagerid', '$fromuserid', '$uid', '$tousername', " . 
			 			TIMENOW . ")");	

					// Update users UNREAD Pager in the user table
					$updatecount = vbpager_update_unread($uid);
				  }
			 }
		$updatecount = vbpager_update_unread($vbulletin->userinfo['userid']);
		exit;	
	 }
 exit;
 }

// #######################################################################
// ################## PAGER MESSAGE LIST [INBOX/OUTBOX] ##################
// #######################################################################

// Start of Pager LOG
if ($_REQUEST['do']=='log')
 {
	$perpage	= $_REQUEST['perpage'];
	$page		= $_REQUEST['page'];
	$dowhat		= $_REQUEST['dowhat'];
	$pagerno	= $_REQUEST['pagerno'];
	$folder 	= $_REQUEST['folder'];
		
	$perpage1 = $vbulletin->options['vbpager_pagermaxperpage'];
	$perpage2 = $perpage1 * 2;
	$perpage3 = $perpage2 * 2;
	$perpage4 = $perpage3 * 2;
	$perpage5 = $perpage4 * 2;

	// only for Logged on user
	if ($vbulletin->userinfo['userid'] == 0)
	 {
		print_no_permission();
	 }

	// Start Delete Pager
	if ($dowhat=="del")
	 {
		if (!is_array($pagerno))
		{
	 		$idname = "Pager ID";
	 		eval(print_standard_error('invalidid'));
		}

		$messageids = array();
		foreach (array_keys($pagerno) AS $pmid)
		 {
			$pmid = intval($pmid);
			$messageids["$pmid"] = $pmid;
		 }
		$receiptids = implode(', ', $messageids);
	
		$updatefield = ($_REQUEST['folder'] == 'outbox') ? " active = 0 " : $updatefield ;
		$updatefield = ($_REQUEST['folder'] == 'inbox') ? " markdeleted = 1 " : $updatefield ;

		$db->query("update " .  TABLE_PREFIX . "pagerreceipt set $updatefield where receiptid in ($receiptids)");

		// Update Deleted pager (if all inbox/sent items delete, then delete original pagertext) Global Update 
		$updateresult = vbpager_update_unread($vbulletin->userinfo['userid']);
	 }
// End of Delete Pager

$thisuserid = $vbulletin->userinfo['userid'];

	// Pager inbox
	if ($folder == 'inbox')
	 {
		$show['inbox']	= TRUE;
		
	// Navigation
	$tmpsql = $db->query_first("SELECT count(*) totpager FROM " .  TABLE_PREFIX . "pagertext AS p 
		LEFT JOIN " .  TABLE_PREFIX . "pagerreceipt AS r ON (p.pagerid=r.pagerid) WHERE 
		touserid = $thisuserid AND readtime > 0 AND deleted=0 AND markdeleted=0");

	$totalpager = $tmpsql[totpager];
	
	if (!isset($perpage))
	 {
		$perpage=$vbulletin->options['vbpager_pagermaxperpage'];
	 }
		$pagenumber = $page;
    if ((!isset($pagenumber) or $pagenumber==0) and $pagenumber!="lastpage")
     {
		$pagenumber = 1;
	 }

  $limitlower=($pagenumber-1)*$perpage+1;
  $limitupper=($pagenumber)*$perpage;

	// Navigation
	$sql = "SELECT p.pagerid, receiptid, pagerreplyid, fromuserid, fromusername, message, dateline, 
		readtime, hidden, deleted, active FROM " .  TABLE_PREFIX . "pagertext AS p LEFT 
		JOIN " .  TABLE_PREFIX . "pagerreceipt AS r 
		ON (p.pagerid=r.pagerid) WHERE touserid = $thisuserid  
		AND readtime > 0 AND deleted=0 AND markdeleted=0 
		ORDER BY dateline DESC LIMIT " . ($limitlower-1) . ", $perpage";

 	if ($limitupper > $totalpager) 
	 {
		$limitupper = $totalpager;
		if ($limitlower>$totalpager)
		 {
			$limitlower=$totalpager-$perpage;
		 }
	 }
  
	$pagenav = construct_page_nav($pagenumber, $perpage, $totalpager, "pager.php?action=pager&do=log&folder=inbox&perpage=$perpage");  

		$result = $db->query($sql);
			$i = 0;
		while ($pagerinfo=$db->fetch_array($result))
		 {
			$i++;
			// Pager vB code/Smilies ON/OFF	(only on pager read)
			$pagerinfo['message']		= ($vbulletin->options['vbpager_pagerallowsmilies']) ? parse_pager_bbcode($pagerinfo['message']) : $pagerinfo['message'] ;
			$pagerinfo['username']		= addslashes($pagerinfo['fromusername']);
			$pagerinfo['username']		= ($pagerinfo[hidden]) ? $vbphrase['n_a'] : $pagerinfo['username'] ;
			$pagerinfo['deliverdate']	= vbdate($vbulletin->options['dateformat'], $pagerinfo['readtime'], true) . " " . vbdate($vbulletin->options['timeformat'], $pagerinfo['readtime']); 
			$pagerinfo[msgdate]			= vbdate($vbulletin->options['dateformat'], $pagerinfo['dateline'], true) . " " . vbdate($vbulletin->options['timeformat'], $pagerinfo['dateline']); 
			eval('$pagerinbox .= "' . fetch_template('pager_messagelistbit') . '";');
		 }
	 }
	// Pager Sent Items
	elseif ($folder == 'outbox')
	 {
		$show['outbox']	= TRUE;		

	// Navigation Page/record count....
	$tmpsql = $db->query_first("SELECT count(*) totpager FROM " .  TABLE_PREFIX . "pagertext AS p 
		LEFT JOIN " .  TABLE_PREFIX . "pagerreceipt AS r ON (p.pagerid=r.pagerid) WHERE 
		fromuserid = $thisuserid AND deleted=0 AND r.active = 1");
	
	$totalpager	= $tmpsql['totpager'];
	$perpage	= $_REQUEST['perpage'];
	if (!isset($perpage))
	 {
		$perpage=$vbulletin->options['vbpager_pagermaxperpage'];
	 }

	$pagenumber = $_REQUEST['page'];
    if ((!isset($pagenumber) or $pagenumber==0) and $pagenumber!="lastpage")
     {
		$pagenumber=1;
	 }

  $limitlower = ($pagenumber - 1) * $perpage + 1;
  $limitupper = ($pagenumber) * $perpage;

	// Navigation
	$sql = "SELECT p.pagerid, receiptid, pagerreplyid, touserid, tousername, message, dateline, 
		readtime, hidden, deleted, active FROM " .  TABLE_PREFIX . "pagertext AS p LEFT 
		JOIN " .  TABLE_PREFIX . "pagerreceipt AS r 
		ON (p.pagerid=r.pagerid) WHERE fromuserid = $thisuserid 
		AND deleted=0 AND r.active = 1 ORDER BY dateline DESC LIMIT " . ($limitlower-1) . ", $perpage";

	if ($limitupper > $totalpager) 
	 {
		$limitupper = $totalpager;
		if ($limitlower > $totalpager)
		 {
			$limitlower=$totalpager-$perpage;
		 }
	 }
	$pagenav = construct_page_nav($pagenumber, $perpage, $totalpager, "pager.php?action=pager&do=log&folder=outbox&perpage=$perpage");

		$result = $db->query($sql);
			$i = 0;
		while ($pagerinfo=$db->fetch_array($result))
		 {
			$i++;
			// Pager vB code/Smilies ON/OFF		(only on pager read)
			$pagerinfo['message'] = ($vbulletin->options['vbpager_pagerallowsmilies']) ? parse_pager_bbcode($pagerinfo['message']) : $pagerinfo['message'] ;
			$pagerinfo['username'] = addslashes($pagerinfo['tousername']);
			if ($pagerinfo['pagerreplyid'])
				if ($db->query_first("select * from " .  TABLE_PREFIX . "pagertext where pagerid=". $pagerinfo['pagerreplyid'] ." and hidden=1"))
			  		$pagerinfo['username'] = $vbphrase['n_a'];
				if ($pagerinfo['readtime'])
			  $pagerinfo[deliverdate] = vbdate($vbulletin->options['dateformat'], $pagerinfo['readtime'], true) . " " . vbdate($vbulletin->options['timeformat'], $pagerinfo['readtime']); 
				else
			  $pagerinfo[deliverdate] = $vbphrase['vbpager_not_read'];
			  $pagerinfo['msgdate'] = vbdate($vbulletin->options['dateformat'], $pagerinfo['dateline'], true) . " " . vbdate($vbulletin->options['timeformat'], $pagerinfo['dateline']); 
	eval('$pageroutbox .= "' . fetch_template('pager_messagelistbit') . '";');		
		 }
	 }
	else
		$show[pagererror]	= TRUE;

	eval('print_output("' . fetch_template('pager_messagelist') . '");');
 }
// END of Pager LOG

// #######################################################################
// ##################### START PAGER BUDDYLIST ###########################
// #######################################################################

if ($_REQUEST['do'] == 'buddylist')
{
	if (!$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	
 	$pagertouserid					= $_REQUEST['puserid'];
	$pagerinfo['sendnewpager']		= TRUE;
	$pagerinfo['showmenu'] 			= TRUE;
	$pagerinfo['pagercanuse']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagercanuse']);
	$pagerinfo['pagercanhide']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerhidename']);
	$pagerinfo['pagerreply']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerreply']);
	$pagerinfo['pagerdisableduser']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerdisableduser']);
	$pagerinfo['pagerinignorelist']	= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagerinignorelist']);
	$pagerinfo['pagertoall']		= ($permissions['pagerpermissions'] & $vbulletin->bf_ugp_pagerpermissions['pagertoall']);
	$pagerinfo['pagerminpost']		= $permissions['pagerminpost'];
	$pagerinfo['pagerminpostperday']= $permissions['pagerminpostperday'];
	$pagerinfo['pagermaxperday']	= $permissions['pagermaxperday'];
	$pagerinfo['pagersendmax']		= intval($permissions['pagersendmax']);
	$pagerinfo['pagersendmaxchar']	= $permissions['pagersendmaxchar'];
	$pagerinfo['pagerquota']		= $permissions['pagerquota'];

require_once(DIR . '/includes/functions_online.php');

	// Variables reused in templates
	$sortfield = $vbulletin->input->clean_gpc('r', 'sortfield', TYPE_NOHTML);
	$sortorder = $vbulletin->input->clean_gpc('r', 'sortorder', TYPE_NOHTML);

	$vbulletin->input->clean_array_gpc('r', array(
		'who'		=> TYPE_STR,
		'ua'		=> TYPE_BOOL,
		));

	if ($sortorder != 'desc')
	 {
		$sortorder = 'asc';
		$oppositesort = 'desc';
	 }
	else
	 { 
		$sortorder = 'desc';
		$oppositesort = 'asc';
	 }

	switch ($sortfield)
	 {
	 	default :
		$sqlsort	= 'user.username';
		$sortfield	= 'username';
	 }
		$whoselected= array();
		$buddylist	= preg_split('/( )+/', trim($vbulletin->userinfo['pagerbuddylist']), -1, PREG_SPLIT_NO_EMPTY);
		$ignorelist	= preg_split('/( )+/', trim($vbulletin->userinfo['pagerignorelist']), -1, PREG_SPLIT_NO_EMPTY);

	if (!$ignorelist)
	 {	 
		$ignorelist[]	= 0;
	 }
	if (!$buddylist)
	 {
		$buddylist[]	= 0;
	 }

		$who	= $vbulletin->GPC['who'];
		$datecut= TIMENOW - $vbulletin->options['cookietimeout'];	
	switch ($vbulletin->GPC['who'])
	{
		case 'buddies':
			$showspiders	= true;
			$whoselected[1] = 'selected="selected"';
			$cond			= " WHERE (user.userid IN (" . implode(',', $buddylist) . ") " . 
						  		" AND user.userid NOT IN (" . implode(',', $ignorelist) . ")) ";
			break;
		default:
			$showmembers	= true;
			$showguests		= true;
			$showspiders	= true;
			$whoselected[0]	= 'selected="selected"';
			$cond			= " WHERE session.lastactivity > $datecut ";
	}

	$sorturl = 'pager.php?action=pager&do=buddylist&' . $vbulletin->session->vars['sessionurl'] .
		($vbulletin->GPC['who'] != '' ? '&who=' . $vbulletin->GPC['who'] : '') . 
		($vbulletin->GPC['ua'] ? '&ua=1' : '');

	$refreshurl = "pager.php?action=pager&do=buddylist&" . $vbulletin->session->vars['sessionurl'] .
		($vbulletin->GPC['who'] != '' ? '&who=' . $vbulletin->GPC['who'] : '') . 
		($vbulletin->GPC['ua'] ? '&ua=1' : '') . '&sort=' . $sortfield . '&order=' . $sortorder;
	
	eval("\$sortarrow[$sortfield] = \"" . fetch_template('forumdisplay_sortarrow') . '";');

	$buddies =& $vbulletin->input->clean_gpc('r', 'buddies', TYPE_STR);

		$buddys = $db->query_read("SELECT user.username, user.lastvisit, (user.options & 
			" . $vbulletin->bf_misc_useroptions['invisible'] . ") 
			AS invisible, user.userid, user.lastactivity AS lastactive, session.lastactivity, 
			user.pageroption, user.pagerbuddyoption, usertextfield.pagerbuddylist, 
			usertextfield.pagerignorelist 
			FROM " . TABLE_PREFIX . "user AS user 
			LEFT JOIN " . TABLE_PREFIX . "session AS session 
			ON (session.userid = user.userid AND session.lastactivity > $datecut) 
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON 
			(usertextfield.userid = user.userid) $cond 
			ORDER BY $sqlsort $oppositesort, 
			session.lastactivity DESC");

	$pagerinfo['pagertoday'] = vbpager_pagertoday();

	// Check for Permission
	$pagererror['minpost']	= (($vbulletin->userinfo['posts'] < $pagerinfo['pagerminpost']) AND ($pagerinfo['pagerminpost'] != 0)) ? TRUE : FALSE ;
	// Check for Banned user
	$pagererror['banuser']	= (vbpager_ban_user()) ? TRUE : FALSE ;
		// Minimum posts today check
		if ($pagerinfo['pagerminpostperday'])
		{
			$posttodaycheck = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "post 
			WHERE userid=" . $vbulletin->userinfo['userid'] . " AND visible = 1 
			AND dateline < " . TIMENOW . " AND dateline > " . (TIMENOW-(24*60*60)));
			
			$pagerinfo['poststoday']	=	$posttodaycheck['count'];
			if ($pagerinfo['poststoday'] < $pagerinfo['pagerminpostperday'])
			{
				$pagerinfo['pagerminpostperday'] = round((float)$pagerinfo['pagerminpostperday'], 2);
				$pagererror['minpostperday']	= TRUE;
			}
		}

	// Check if user Enabled/Disabled Pager
	if ($vbulletin->userinfo['pageroption'] == 0)
	 {
	 	$pagererror['disabledpager'] = TRUE;
		$pagerinfo['errorinfo']		.= "error";
	 }
	$pagererror['pagercanuse']		= (!$pagerinfo['pagercanuse']) ? TRUE : FALSE ;
	$pagererror['pagermaxperday']	= (($pagerinfo['pagertoday'] >= $pagerinfo['pagermaxperday']) && ($pagerinfo['pagermaxperday'] != 0)) ? TRUE : FALSE ;
	$pagererror['minpostperday']	= ($pagerinfo['poststoday'] < $pagerinfo['pagerminpostperday']) ? TRUE : FALSE ;
		
	if ($pagerinfo['pagermaxperday'] != 0)
	 {
		$pagerinfo['pagerlefttoday']= $pagerinfo['pagermaxperday'] - $pagerinfo['pagertoday'];
	 }
	if ($pagerinfo['pagerquota'] > 0)
	 {
	 	$pagerinfo['pagertotal'] 	= vbpager_totalpager();
 	 	$pagerinfo['pagerquotaleft']= $pagerinfo['pagerquota'] - $pagerinfo['pagertotal'];
 	 	$pagererror['pagerquota']	= ($pagerinfo['pagerquotaleft'] <= 0) ? TRUE : FALSE;
	 }
 	
	if ($pagererror['pagercanuse'] OR $pagererror['minpost'] OR $pagererror['pagermaxperday'] OR $pagererror['minpostperday'] OR $pagererror['banuser'] OR $pagererror['pagerquota'] OR $pagererror['disabledpager'] OR $pagererror['banuser'])
	 {
		$pagererror['disable']		= "disabled";
		$pagerdisable				= TRUE;
	 }
		
		$onlineusers	= '';
		$offlineusers	= '';
		$newusersound	= '';
		$lastonline		= array();

		if (isset($buddies))
		{
			$buddies 	= urldecode($buddies);
			$lastonline	= explode(' ', $buddies);
		}
		$buddies		= '0 ';

	// *************** LOOP for all LIST of Online/Buddies ***************
	require_once(DIR . '/includes/functions_bigthree.php');
	while ($buddy = $db->fetch_array($buddys))
	{
		global $doneuser;
		if (($doneuser["$buddy[username]"]) OR ($buddy['userid'] == $vbulletin->userinfo['userid']))
		 {
			continue;				
		 }

		// Buddies Permission to use pager
		$pagerinfo['inignorelist']	= FALSE;
		$pagerinfo['disabledpager']	= FALSE;
		$pagerinfo['pagerfrombuddy']= TRUE;
		$pagerinfo['cansend']		= TRUE;
		$pagerinfo['errorinfo']		= "";

		if ($pagerinfo['pagertoall'] > 0)
		{
			$pagerinfo['inignorelist']	= FALSE;
			$pagerinfo['disabledpager']	= FALSE;
			$pagerinfo['pagerfrombuddy']= TRUE;
		}
		else
		{
			// ******* $pagerinfo['banuser'] ******* Buddy is a banned user
			$pagerinfo['errorinfo']		.= (vbpager_ban_user($buddy['userid'])) ? "error" : "";

			// ******* $pagerinfo['inignorelist'] ******* Buddy is ignoring me
			if ($buddy['pagerignorelist'])
			 {
				$tempignore = explode(' ', $buddy['pagerignorelist']);
				if (in_array($vbulletin->userinfo['userid'], $tempignore))
				 {
					$pagerinfo['inignorelist']	 = TRUE;
					$pagerinfo['errorinfo']		.= "error";
			 	 }
			 }

			// ******* $pagerinfo['disabledpager'] ******* Buddy has Disabled Pager
			if ($buddy['pageroption'] == 0)
			 {
			 	$pagerinfo['disabledpager']  = TRUE;
				$pagerinfo['errorinfo']		.= "error";
			 }

			// ******* $pagerinfo['pagerfrombuddy'] ******* Buddy is allowing pager from his/her buddies only
			if($buddy['pagerbuddyoption'])
			 {
				if ($buddy['pagerbuddylist'])
				 {
					$tempignore = explode(' ', $buddy['pagerbuddylist']);
					if (!in_array($vbulletin->userinfo['userid'], $tempignore))
					 {
						$pagerinfo['pagerfrombuddy'] = FALSE;
						$pagerinfo['errorinfo']		.= "error";
			 		 }
				 }
		 		else
				 {
					$pagerinfo['pagerfrombuddy'] = FALSE;
					$pagerinfo['errorinfo']		.= "error";		  
				 }
			 }
		}

	if (!$pagerdisable)
	 {
		$pagererror['disable'] = ($buddy['userid'] == $vbulletin->userinfo['userid']) ? "disabled" : "" ;
	 }
	 	$pagererror['disable']	= ($pagerinfo['errorinfo']) ? "disabled" : $pagererror['disable'] ;
		$pagerinfo['cansend']	= ($pagererror['disable']=="disabled") ? FALSE : $pagerinfo['cansend'] ;
	
			// Buddies Permission to use pager
			$doneuser["$buddy[userid]"]		= TRUE ;
			$doneuser["$buddy[username]"]	= TRUE ;
			$pagerinfo['userid']			= $buddy['userid'];
			$pagerinfo['username']			= $buddy['username'];			
						
			$userlastactivity = ($buddy['lastactivity']) ? $buddy['lastactivity'] : $buddy['lastactive'] ;
			$buddy['lastonlinetime'] = vbdate($vbulletin->options['timeformat'], $userlastactivity, true);			

		$onlineresult = 0;
	if ($buddy['lastactive'] > $datecut AND $buddy['lastvisit'] != $buddy['lastactive'])
	{
		if ($buddy['invisible'])
		{
			if (($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) OR $buddy['userid'] == $vbulletin->userinfo['userid'])
			{
				// user is online and invisible BUT bbuser can see them
				$buddy['invisiblemark'] = '*';
				$onlineresult = 2;
			}
		}
		else
		{
			// user is online and visible
			$onlineresult = 1;
		}
	}
			$pagerinfo['buddyuser'] = (in_array($buddy['userid'], $buddylist)) ? TRUE : $pagerinfo['buddyuser'];
			$pagerinfo['ignoreuser'] = (in_array($buddy['userid'], $ignorelist)) ? TRUE : $pagerinfo['ignoreuser'];	
					
			if ($buddy['lastactivity'])
			{
				if ($onlineresult == 1)
				{
					$buddy['statusicon'] = 'online';
					$buddy['statusicon'] = (in_array($buddy['userid'], $buddylist)) ? 'buddylist_online' : $buddy['statusicon'];
					$buddy['statusicon'] = (in_array($buddy['userid'], $ignorelist)) ? 'ignorelist_online' : $buddy['statusicon'] ;
				}
				else
				{
						$buddy['statusicon'] = 'invisible';	
					if (in_array($buddy['userid'], $buddylist))
					 {
						$buddy['statusicon'] = ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseehidden']) ? 'buddylist_invisible' : 'offline' ;
					 }
						$buddy['statusicon'] = (in_array($buddy['userid'], $ignorelist)) ? 'ignorelist_invisible' : $buddy['statusicon'] ;
				}
				$buddies .= $buddy['userid'] . ' ';
			}
			else
			{
				$buddy['statusicon'] = 'offline';
			}	
				$buddy['status'] = $vbphrase['pager_' . $buddy[statusicon] . ''];

// Quick menu add/remove AJAX buddy update
					$pagerinfo['showignore']	= FALSE;
					$pagerinfo['showdelbuddy']	= FALSE;
					$pagerinfo['showbuddy']		= FALSE;
					$pagerinfo['showdelignore']	= FALSE;
				if (in_array($buddy['userid'], $buddylist))
				 {
					$pagerinfo['showignore']	= TRUE;
					$pagerinfo['showdelbuddy']	= TRUE;
				 }
					
				if (in_array($buddy['userid'], $ignorelist))
				 {
					$pagerinfo['showbuddy']		= TRUE;
					$pagerinfo['showdelignore']	= TRUE;
				 }
				 
				if (!$pagerinfo['showbuddy'] AND !$pagerinfo['showignore'])
				 {
					$pagerinfo['showignore']	= TRUE;
					$pagerinfo['showbuddy']		= TRUE;
				 }
// End Quick menu add/remove AJAX buddy update
					
			if ($buddy['statusicon'] != 'offline')
			{
				$pagerinfo['onlinestat'] = "_on";				 
				if (!in_array($buddy['userid'], $lastonline) AND !empty($lastonline) AND $onlineresult >= 1)
				{
					// add name to top of list
					eval('$onlineusers = "' . fetch_template('pagerbuddylistbit') . '" . $onlineusers;');
				}
			}
			else
			{
				$pagerinfo['onlinestat'] = "_off";
				if($who == 'buddies')
				 {
					eval('$offlineusers .= "' . fetch_template('pagerbuddylistbit') . '";');
				 }
			}
		}
	 $pagererror['disable'] = (!$pagerdisable) ? "" : $pagererror['disable'];
}

// ############################################################################
// ###################### ADD/EDIT PAGER BUDDY/IGNORE LISTS ###################
// ############################################################################

if ($_REQUEST['do'] == 'editlist')
{
	$pagerinfo['pagersendmaxchar']	= $permissions['pagersendmaxchar'];
	$userlist = 'buddy';

	// get buddy ids
	if ($vbulletin->userinfo['pagerbuddylist'])
	{
		$buddy_ids = explode(' ', trim($vbulletin->userinfo['pagerbuddylist']));
	}
	else
	{
		$buddy_ids = array();
	}
	// get ignore ids
	if ($vbulletin->userinfo['pagerignorelist'])
	{
		$ignore_ids = explode(' ', trim($vbulletin->userinfo['pagerignorelist']));
	}
	else
	{
		$ignore_ids = array();
	}
	// get merged list
	$bothlists = array_merge($buddy_ids, $ignore_ids);
	$listusers = array();
	if (!empty($bothlists))
	{
		$users = $db->query_read("
			SELECT userid, username FROM " . TABLE_PREFIX . "user
			WHERE userid IN (" . implode(',', $bothlists) . ")
			ORDER BY username
			");
		while ($userinfo = $db->fetch_array($users))
		{
			if ($userinfo['userid'] != 0)
			{
				if (in_array($userinfo['userid'], $buddy_ids))
				{
					$listusers['buddy']["$userinfo[userid]"] = $userinfo['username'];
				}
				if (in_array($userinfo['userid'], $ignore_ids))
				{
					$listusers['ignore']["$userinfo[userid]"] = $userinfo['username'];
				}
			}
		}
	}

	$buddy_listbits = '';
	if (!empty($listusers['buddy']))
	{
		foreach ($listusers['buddy'] AS $userid => $username)
		{
			eval('$buddy_listbits .= "' . fetch_template('modifylistbit') . '";');
		}
	}

	$ignore_listbits = '';
	if (!empty($listusers['ignore']))
	{
		foreach ($listusers['ignore'] AS $userid => $username)
		{
			eval('$ignore_listbits .= "' . fetch_template('modifylistbit') . '";');
		}
	}
}

// #######################################################################
// ################### UPDATE PAGER BUDDY/IGNORE LISTS ###################
// #######################################################################

if ($_POST['do'] == 'updatelist')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userlist'	=> TYPE_NOHTML,
		'listbits'	=> TYPE_ARRAY_NOHTML,
	));

	$checkvar = 'pagerignorelist';
	if ($vbulletin->GPC['userlist'] != 'buddy')
	{
		$vbulletin->GPC['userlist'] = 'ignore';
		$checkvar = "pagerbuddylist";
	}
		
	$var = 'pager' . $vbulletin->GPC['userlist'] . 'list';

	// cache exiting userlist ids
	unset($useridcache);
	$ids 			= str_replace(' ', ',', trim($vbulletin->userinfo["$var"]));
	$checkids		= str_replace(' ', ',', trim($vbulletin->userinfo["$checkvar"]));
	$checkbuddyids 	= ($checkids) ? explode(',', $checkids) : array('0');
	
	if ($ids != '')
	{
		$users = $db->query_read("
			SELECT username, usergroupid, user.userid, moderator.userid as moduserid
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . TABLE_PREFIX . "moderator AS moderator ON(user.userid = moderator.userid)
			WHERE user.userid IN($ids)
			");
		while ($user = $db->fetch_array($users))
		{
			$user['username'] = strtolower($user['username']);
			$useridcache["{$user['username']}"] = $user;
		}
	}

	$listids = '';
	foreach ($vbulletin->GPC['listbits'] AS $key => $val)
	{
		$val = $db->escape_string(strtolower($val));
		if ($val == $vbulletin->userinfo['username'])
		 {
			continue;
		 }
			
		if (!empty($val))
		{
			if (!is_array($useridcache["$val"]))
			{
				if ($userid = $db->query_first("
					SELECT userid, username, usergroupid, membergroupids
					FROM " . TABLE_PREFIX . "user AS user
					WHERE username = '$val'
				"))
				{
					$useridcache["$val"] = $userid;
				}
			}
			else
			{
				$userid = $useridcache["$val"];
			}
			if ($userid['userid'])
			{
				if ($checkbuddyids)
				 {
					if (in_array($userid['userid'], $checkbuddyids))
					{
				 			$updatelist = 1;
				 			$tempids = array('0');
				 		foreach ($checkbuddyids AS $ids)
				 		 {
				 	 		if ($ids != $userid['userid'])
				 	 		 {
				 	 	 		$tempids[] = $ids;
				 	 	 	 }
				 		 }
				 	 		$checkbuddyids = ($tempids) ? $tempids : $checkbuddyids ;
					 }
				}

				$uglist = $userid['usergroupid'] . iif(trim($userid['membergroupids']), ",$userid[membergroupids]");
				if ($var == 'ignorelist' AND !$vbulletin->options['ignoremods'] AND can_moderate(0, '', $userid['userid'], $uglist) AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
				{
					eval(standard_error(fetch_error('listignoreuser', $userid['username'])));
				}
				else if ($vbulletin->GPC['userlist'] == 'ignore' AND $vbulletin->userinfo['userid'] == $userid['userid']) // this code only prevents users from adding themselves to their ignore list
				{
					eval(standard_error(fetch_error('cantlistself_' . $vbulletin->GPC['userlist'])));
				}
				else
				{
					if (empty($done["{$userid['userid']}"]))
					{
						$listids .= " $userid[userid]";
						$done["{$userid['userid']}"] = 1;
					}
				}
			}
			else
			{
				eval(standard_error(fetch_error('listbaduser', $val, $vbulletin->session->vars['sessionurl_q'])));
			}
		}
	}

	$listids = trim($listids);

	require_once(DIR . '/includes/functions_databuild.php');
	build_usertextfields($var, $listids);

	if ($updatelist)
	{
		build_usertextfields($checkvar, $checkbuddyids);
	}

	if (is_array($printdebug))
	{
		foreach ($printdebug AS $line => $text)
		{
			$out .= $text;
		}
	}
	eval(print_standard_redirect('updatelist_' . $vbulletin->GPC['userlist']));
}

if ($_POST['do'] == 'updatelist' OR $_REQUEST['do'] == 'editlist' OR $_REQUEST['do'] == 'buddylist')
 {
	eval('print_output("' . fetch_template('PAGERBUDDYLIST') . '");');
	$vbulletin->input->clean_gpc('r', 'template', TYPE_NOHTML);
 }

// #######################################################################
// ####################### Download PAGER Messages #######################
// #######################################################################

if ($_REQUEST['do'] == 'downloadpager')
{
	$dowhat = $vbulletin->input->clean_gpc('r', 'dowhat', TYPE_NOHTML);
	$folder = $vbulletin->input->clean_gpc('r', 'folder', TYPE_NOHTML);
	
	$thisuserid = $vbulletin->userinfo['userid'];
	if (!$thisuserid)
	 {
	 	print_no_permission();
	 }
	require_once(DIR . '/includes/functions_file.php');

	if ($folder == 'inbox')
	 {
		//****************** INBOX QUERY ******************
		$pagers = $db->query_read("SELECT p.pagerid, receiptid, pagerreplyid, fromuserid, fromusername, message, dateline, 
		readtime, hidden, deleted, active FROM " .  TABLE_PREFIX . "pagertext AS p LEFT 
		JOIN " .  TABLE_PREFIX . "pagerreceipt AS r 
		ON (p.pagerid=r.pagerid) WHERE touserid = $thisuserid  
		AND readtime > 0 AND deleted=0 AND markdeleted=0 
		ORDER BY dateline DESC ");
	 }
	else
	 {
		//****************** Sent Items QUERY ******************
		$pagers = $db->query_read("SELECT p.pagerid, receiptid, pagerreplyid, touserid, tousername, message, dateline, 
		readtime, hidden, deleted, active FROM " .  TABLE_PREFIX . "pagertext AS p LEFT 
		JOIN " .  TABLE_PREFIX . "pagerreceipt AS r 
		ON (p.pagerid=r.pagerid) WHERE fromuserid = $thisuserid 
		AND deleted=0 AND r.active = 1 ORDER BY dateline DESC");
	 }

	// check to see that we have some messages to work with
	if (!$db->num_rows($pagers))
	{
		eval(standard_error(fetch_error('pager_no_pager_to_download')));
	}

	// Start Download based on type
	switch ($dowhat)
	{
		// *****************************
		// download as XML
		case 'xml':

			require_once(DIR . '/includes/class_xml.php');
			$xml = new XMLexporter();

			$xml->add_group('pagermessages');
			$xml->add_group('' . $folder . '');
			$i = 0;
			while ($pager = $db->fetch_array($pagers))
			{
				$i++;
				$pagermsg['slno']		= $i;
			  if ($folder == 'inbox')
			   {
				$pagermsg['fromuser']	= unhtmlspecialchars($pager['fromusername']);
			   }
			  else
			   {
				$pagermsg['touser']		= unhtmlspecialchars($pager['tousername']);
			   }
				$pagermsg['sent']		= vbdate('Y-m-d H:i', $pager['dateline'], false, false);
				$pagermsg['received']	= ($pager['readtime']) ? vbdate('Y-m-d H:i', $pager['readtime'], false, false) : $vbphrase['pager_not_yet'] ;
				$pagermsg['message']	= str_replace("\n", "\r\n", str_replace("\r\n", "\n", $pager['message']));
				$pagermsg['message']	= fetch_censored_text($pagermsg['message']);

				 $xml->add_group('pagermessage');
				// make values save
				foreach ($pagermsg AS $key => $val)
				{
					$xml->add_tag($key, $val);
				}
				 $xml->close_group();
			 }
			$xml->close_group();
			$xml->close_group();
			
			$doc = "<?xml version=\"1.0\" encoding=\"$stylevar[charset]\"?>\r\n\r\n";
			$doc .= "<!-- " . $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . " -->\r\n";

			$doc .= $xml->output();
			$xml = null;

			// download the file
			file_download($doc, "vBPager_($folder)_" . $vbulletin->userinfo['username'] . "_" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.xml', 'text/xml');
		break;

		// *****************************
		// download as CSV
		case 'csv':
			// column headers
			$csv  = "#, ";
			$csv .= ($folder=='inbox') ? "$vbphrase[pager_from]" : "$vbphrase[pager_to]";
			$csv .= ", $vbphrase[pager_sent_time], $vbphrase[pager_received_time], $vbphrase[message] \r\n";

			$i = 0;
			while ($pager = $db->fetch_array($pagers))
			{
				$i++;
				$pagermsg['slno']		= $i;
				$pagermsg['fromto']		= unhtmlspecialchars(($folder=='inbox') ? $pager['fromusername'] : $pager['tousername']);
				$pagermsg['sent']		= vbdate('Y-m-d H:i', $pager['dateline'], false, false);
				$pagermsg['receive']	= ($pager['readtime']) ? vbdate('Y-m-d H:i', $pager['readtime'], false, false) : $vbphrase['pager_not_yet'];
				$pagermsg['message']	= str_replace("\n", "\r\n", str_replace("\r\n", "\n", $pager['message']));
				$pagermsg['message']	= fetch_censored_text($pagermsg['message']);
				
				// make values save
				foreach ($pagermsg AS $key => $val)
				{
					if (preg_match('/\,|"/siU', $val))
					{
						$pagermsg["$key"] = '"' . str_replace('"', '""', $val) . '"';
					}
				}
				// output the message row
				$csv .= implode(',', $pagermsg) . "\r\n";
			}

			unset($pager);
			$db->free_result($pagers);

			// download the file
			file_download($csv, "vBPager_($folder)_" . $vbulletin->userinfo['username'] . "_" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.csv', 'text/x-csv');
		break;

		// *****************************
		// download as TEXT
		case 'txt':
			
			$txt = $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . "\r\n";
			$txt .= "################################################################################\r\n";
			$txt .= "$vbphrase[pager_vbpager] :\t " . $vbulletin->userinfo['username'] . "\t$folder\r\n";
			$txt .= "################################################################################\r\n\r\n";

			$i = 0;
			while ($pager = $db->fetch_array($pagers))
			{
				$i++;
				$pagermsg['fromto']		= unhtmlspecialchars(($folder=='inbox') ? $pager['fromusername'] : $pager['tousername']);
				$pagermsg['sent']		= vbdate('Y-m-d H:i', $pager['dateline'], false, false);
				$pagermsg['receive']	= ($pager['readtime']) ? vbdate('Y-m-d H:i', $pager['readtime'], false, false) : $vbphrase['pager_not_yet'] ;
				$pagermsg['message']	= str_replace("\n", "\r\n", str_replace("\r\n", "\n", $pager['message']));
				$pagermsg['message']	= fetch_censored_text($pagermsg['message']);

				$txt .= "================================================================================\r\n";
				$txt .= ($folder=='inbox') ? "$vbphrase[pager_from]\t\t" . ":\t" . $pagermsg['fromto'] . "\r\n" : "$vbphrase[pager_to]\t\t" . ":\t" . $pagermsg['fromto'] . "\r\n";
				$txt .= "$vbphrase[pager_sent_time] \t\t:\t" . $pagermsg['sent'] . "\r\n";
				$txt .= "$vbphrase[pager_received_time] \t\t:\t" . $pagermsg['receive'] . "\r\n";
				$txt .= "--------------------------------------------------------------------------------\r\n";
				$txt .= "$pagermsg[message]\r\n\r\n";
			}
			unset($pager);
			$db->free_result($pagers);

			// download the file
			file_download($txt, "vBPager_($folder)_" . $vbulletin->userinfo['username'] . "_" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.txt', 'text/plain');
		break;

		// *****************************
		// unknown download format
		default:
			eval(standard_error(fetch_error('invalidid', $vbphrase['file_type'], $vbulletin->options['contactuslink'])));
		break;
	}

}

// #######################################################################
// ######################## PAGER LOCAL FUNCTIONS ########################
// #######################################################################


